import {connect} from 'react-redux';
import {Finish} from './Finish.jsx';
import {hasExp} from '@blocks/selectors';
import {setupMode} from '@blocks/authv2/actions';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {isPhoneNumberUpdated, isPhoneOperationConflict, checkDataUrl},
        settings: {tld},
        common: {profile_url, retpath}
    } = state;

    return {
        retpath: hasExp(state, 'auth-check-data-exp') ? checkDataUrl : retpath,
        profileUrl: profile_url,
        tld,
        isPhoneNumberUpdated,
        isPhoneOperationConflict
    };
};

const mapDispatchToProps = {
    setupMode
};

const ConnectedFinish = connect(mapStateToProps, mapDispatchToProps)(Finish);

export {ConnectedFinish as Finish};
