import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import Title from '@blocks/authv2/components/Title/Title';
import {LandingLink} from '@blocks/authv2/components/ChangePassword/LandingLink/LandingLink';

import './FinishExp.styl';

const HELP_DOC_LINK = 'https://yandex.%tld/support/id/security/login-challenge.html#different-device';

const b = cn('ChangePassword');

export class FinishExp extends PureComponent {
    componentDidMount() {
        this.props.setupMode('customLogo');
    }

    componentWillUnmount() {
        this.props.setupMode('');
    }

    render() {
        const {retpath, profileUrl, tld} = this.props;

        return (
            <>
                <div className={b('header')}>
                    <div role='presentation' className={b('icon', {type: 'success'})} />
                    <Title>{i18n('_AUTH_.change_pwd_success_title')}</Title>
                </div>
                <div className={b('form')}>
                    <div className={b('descriptionText')}>
                        {i18n('_AUTH_.change_pwd_success_text')}
                        <a className='Link_view_default' href={HELP_DOC_LINK.replace('%tld', tld)}>
                            {i18n('_AUTH_.change_pwd_success_text_link')}
                        </a>
                    </div>

                    <div data-t='pssp:submit-finish-btn'>
                        <Button
                            type='link'
                            size='l'
                            url={retpath || profileUrl}
                            view='action'
                            width='max'
                            text={i18n('_AUTH_.RestoreLogin.next-step')}
                        />
                    </div>
                    <LandingLink />
                </div>
            </>
        );
    }
}

FinishExp.propTypes = {
    profileUrl: PropTypes.string,
    retpath: PropTypes.string,
    tld: PropTypes.string,
    setupMode: PropTypes.func.isRequired
};
