import {connect} from 'react-redux';
import {FinishExp} from './FinishExp.jsx';
import {hasExp} from '@blocks/selectors';
import {setupMode} from '@blocks/authv2/actions';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {checkDataUrl},
        settings: {tld},
        common: {profile_url, retpath}
    } = state;

    return {
        retpath: hasExp(state, 'auth-check-data-exp') ? checkDataUrl : retpath,
        profileUrl: profile_url,
        tld
    };
};

const mapDispatchToProps = {
    setupMode
};

const ConnectedFinishExp = connect(mapStateToProps, mapDispatchToProps)(FinishExp);

export {ConnectedFinishExp as FinishExp};
