import React, {PureComponent} from 'react';
import {PropTypes} from 'prop-types';
import Title from '@blocks/authv2/components/Title/Title';
import {Button} from '@plibs/pcomponents/Button';
import {LandingLink} from '../LandingLink/LandingLink';
import metrika from '@blocks/metrics';
import {cn} from '@bem-react/classname';

import './Info.styl';

const b = cn('Info');

export class Info extends PureComponent {
    componentDidMount() {
        const {reason, setupMode} = this.props;

        setupMode('customLogo');
        metrika.send(['Показ экрана принудительной смены пароля', `причина: ${reason}`]);
    }

    proceedToNextStep = () => {
        const {updateChangePasswordStep, nextStep} = this.props;

        updateChangePasswordStep(nextStep);
        metrika.send(['Принудительная смена пароля', 'переход на шаг с капчей']);
    };

    sendMetric = () => {
        metrika.send(['Принудительная смена пароля', 'переход на анкету']);
    };

    componentWillUnmount() {
        this.props.setupMode('');
    }

    render() {
        const {reason, descriptionText, title, btnText, semiautoUrl, icon} = this.props;

        return (
            <>
                <div className={b('header')}>
                    <div role='presentation' className={b('icon', {type: icon})} />
                    <Title>{title}</Title>
                </div>
                <div className={b('form')}>
                    <div className={b('description')}>
                        {reason === 'restorationForm' ? (
                            <div dangerouslySetInnerHTML={{__html: descriptionText}} />
                        ) : (
                            descriptionText
                        )}
                    </div>

                    <div data-t='pssp:submit-change-pwd-btn'>
                        {reason === 'restorationForm' ? (
                            <Button
                                onClick={this.sendMetric}
                                url={semiautoUrl}
                                type='link'
                                text={btnText}
                                width='max'
                                size='l'
                            />
                        ) : (
                            <Button onClick={this.proceedToNextStep} text={btnText} width='max' size='l' />
                        )}
                    </div>
                    <LandingLink />
                </div>
            </>
        );
    }
}

Info.propTypes = {
    descriptionText: PropTypes.string.isRequired,
    setupMode: PropTypes.func.isRequired,
    updateChangePasswordStep: PropTypes.func.isRequired,
    reason: PropTypes.string,
    title: PropTypes.string.isRequired,
    btnText: PropTypes.string.isRequired,
    semiautoUrl: PropTypes.string,
    icon: PropTypes.string,
    nextStep: PropTypes.string.isRequired
};
