import {connect} from 'react-redux';
import {Info} from './Info';
import {setupMode} from '@blocks/authv2/actions';
import {updateChangePasswordStep} from '@blocks/authv2/actions/forcePasswordChange';
import {formatLocTextWithLink} from '@blocks/authv2/utils/formatLocTextWithLink';

const REASON_TEXTS = {
    changePassword: {
        title: i18n('_AUTH_.change_pwd_title'),
        text: i18n('_AUTH_.change_pwd_text'),
        button: i18n('_AUTH_.change_pwd_btn')
    },
    accountRestricted: {
        title: i18n('_AUTH_.access_temp_restricted'),
        text: i18n('_AUTH_.pwd_access_restricted_text'),
        button: i18n('_AUTH_.account_restricted_btn')
    },
    restorationForm: {
        title: i18n('_AUTH_.access_temp_restricted'),
        text: i18n('_AUTH_.account_cant_auto_restore'),
        button: i18n('_AUTH_.fill_in_form')
    }
};
const mapStateToProps = (state = {}) => {
    const {
        changePassword = {},
        auth: {form}
    } = state;
    const {reason, semiautoUrl} = changePassword;
    const reasonTexts = REASON_TEXTS[reason] || REASON_TEXTS.accountRestricted;
    const {login} = form;
    const isChangePwdReason = reason === 'changePassword';

    return {
        title: reasonTexts.title,
        descriptionText:
            reason === 'restorationForm'
                ? formatLocTextWithLink(reasonTexts.text.replace('%login%', `<strong>${login}</strong>`), semiautoUrl)
                : reasonTexts.text,
        reason,
        btnText: reasonTexts.button,
        semiautoUrl,
        icon: isChangePwdReason ? 'key' : 'lock',
        nextStep: isChangePwdReason ? 'password' : 'captcha'
    };
};
const mapDispatchToProps = {
    updateChangePasswordStep,
    setupMode
};

const ConnectedInfo = connect(mapStateToProps, mapDispatchToProps)(Info);

export {ConnectedInfo as Info};
