import React from 'react';
import {useSelector} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {Link} from '@components/Link';
import metrika from '@blocks/metrics';

import './LandingLink.styl';

const LINK_URL = 'https://id.yandex.%tld/howtoprotectyourid';
const sendMetrics = () => metrika.send('Нажали на "Как Яндекс защищает данные"');

export const LandingLink = () => {
    const isShowLandingLinkExp = useSelector(({common} = {}) => hasExp({common}, 'show_landing_link_exp'));
    const tld = useSelector(({settings} = {}) => settings.tld);

    if (isShowLandingLinkExp) {
        return (
            <div data-t='pssp:security-landing-link' className='landingLink'>
                <Link
                    onClick={sendMetrics}
                    href={LINK_URL.replace('%tld', tld === 'ru' ? tld : 'com')}
                    theme='normal'
                    target='_blank'
                    rel='noopener noreferrer'
                >
                    {i18n('_AUTH_.pwd.security_landing_link')}
                </Link>
            </div>
        );
    }

    return null;
};
