import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Password} from '@components/Password';
import {PasswordConfirm} from '@components/PasswordConfirm';
import {Button} from '@components/Button';
import commitPassword from '@blocks/authv2/actions/forcePasswordChange/commitPassword';
import Title from '@blocks/authv2/components/Title/Title';

export class PasswordInput extends PureComponent {
    handleSubmit = (event) => {
        event.preventDefault();
        this.props.dispatch(commitPassword());
    };

    render() {
        const {trackId, login, authUrl} = this.props;

        return (
            <Fragment>
                <Title>{i18n('_AUTH_.set_new_pwd')}</Title>
                <form
                    method='post'
                    className={`passp-normal_margin-form`}
                    action={authUrl}
                    onSubmit={this.handleSubmit}
                >
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <input
                        className='g-hidden'
                        type='text'
                        name='login'
                        id='login'
                        readOnly={true}
                        autoComplete='username'
                        value={login}
                    />
                    <Password shouldValidate={true} validationTrack={trackId} size='l' view='big-input' />
                    <PasswordConfirm size='l' view='big-input' />
                    <div data-t='pssp:commit-password'>
                        <Button
                            onClick={this.handleSubmit}
                            text={i18n('_AUTH_.RestoreLogin.next-step')}
                            width='max'
                            size='l'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

PasswordInput.propTypes = {
    dispatch: PropTypes.func.isRequired,
    trackId: PropTypes.string,
    authUrl: PropTypes.string,
    login: PropTypes.login
};
