import {connect} from 'react-redux';
import {PasswordInput} from './PasswordInput.jsx';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getTrackId} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {step},
        common: {authUrl},
        form = {},
        auth: {form: authForm}
    } = state;
    const {password, password_confirm} = form;

    return {
        step,
        login: authForm && authForm.login,
        password,
        passwordConfirm: password_confirm,
        trackId: getTrackId(state, TRACK_TYPES.COMMON),
        authUrl
    };
};

const ConnectedPasswordInput = connect(mapStateToProps)(PasswordInput);

export {ConnectedPasswordInput as PasswordInput};
