import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Link} from '@components/Link';
import {PhoneConfirmation} from '@screens/PhoneConfirmation';
import {Button} from '@components/Button';
import Title from '@blocks/authv2/components/Title/Title';
import api from '@blocks/api';

import './PhoneInput.styl';

const b = cn('PhoneInput');

export class PhoneInput extends PureComponent {
    sendCode = (event) => {
        if (event) {
            event.preventDefault();
        }

        this.props.confirmPhone();
    };

    checkCode = () => {
        this.props.checkPhoneCode();
    };

    handlePhoneUnavailable = () => {
        const {question, semiautoUrl, trackId} = this.props;

        api.writeStatbox({
            track_id: trackId,
            mode: 'change_password_force',
            action: 'change_password_number_is_unavailable'
        });

        if (question) {
            this.props.updateChangePasswordStep('question');
            this.props.setPhoneNumberUpdated(true);
            return;
        }

        location.href = semiautoUrl;
    };

    render() {
        const {number, status, trackId, authUrl, error} = this.props;

        if (status === 'code-sent') {
            return (
                <form method='post' className={b('content')} action={authUrl} onSubmit={this.checkCode}>
                    <PhoneConfirmation onConfirm={this.checkCode} onRetry={this.sendCode} />
                </form>
            );
        }

        return (
            <Fragment>
                <Title>
                    <span dangerouslySetInnerHTML={{__html: i18n('_AUTH_.check_phone_title')}} />
                </Title>
                <div className={b('content')}>
                    <div className={b('formHint')}>
                        <strong className={b('hintNumber')}>{number}</strong>
                        <div className='passp-form-field__link'>
                            <Link onClick={this.handlePhoneUnavailable} pseudo={true}>
                                {i18n('_AUTH_.number_is_unavailable')}
                            </Link>
                        </div>
                    </div>

                    <form method='post' action={authUrl}>
                        <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                        <div data-t='pssp:submit-send-code-btn'>
                            {error.text && (
                                <div
                                    className='passp-form-field__error'
                                    data-t='field:error-phone'
                                    aria-live='polite'
                                    dangerouslySetInnerHTML={{__html: error.text}}
                                />
                            )}
                            <Button
                                onClick={this.sendCode}
                                text={i18n('_AUTH_.restore.get.code')}
                                width='max'
                                size='l'
                            />
                        </div>
                    </form>
                </div>
            </Fragment>
        );
    }
}

PhoneInput.propTypes = {
    number: PropTypes.string,
    question: PropTypes.object,
    semiautoUrl: PropTypes.string.isRequired,
    status: PropTypes.string.isRequired,
    confirmPhone: PropTypes.func.isRequired,
    checkPhoneCode: PropTypes.func.isRequired,
    setPhoneNumberUpdated: PropTypes.func.isRequired,
    updateChangePasswordStep: PropTypes.func.isRequired,
    trackId: PropTypes.string,
    authUrl: PropTypes.string,
    error: PropTypes.object
};
