import {connect} from 'react-redux';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getTrackId} from '@blocks/selectors';
import {PhoneInput} from './PhoneInput.jsx';
import {updateChangePasswordStep, setPhoneNumberUpdated} from '@blocks/authv2/actions/forcePasswordChange';
import checkPhoneCode from '@blocks/authv2/actions/forcePasswordChange/checkPhoneCode';
import confirmPhone from '@blocks/authv2/actions/forcePasswordChange/confirmPhone';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {number, question, semiautoUrl, status},
        common: {authUrl},
        form
    } = state;
    const {errors = {}} = form;

    return {
        number,
        question,
        semiautoUrl,
        status,
        authUrl,
        error: errors.phone || {},
        trackId: getTrackId(state, TRACK_TYPES.COMMON)
    };
};

const mapDispatchToProps = {
    updateChangePasswordStep,
    setPhoneNumberUpdated,
    confirmPhone,
    checkPhoneCode
};

const ConnectedPhoneInput = connect(mapStateToProps, mapDispatchToProps)(PhoneInput);

export {ConnectedPhoneInput as PhoneInput};
