import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './QuestionInput.styl';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import checkAnswer from '@blocks/authv2/actions/forcePasswordChange/checkAnswer';
import Title from '@blocks/authv2/components/Title/Title';

const b = cn('QuestionInput');

export class QuestionInput extends PureComponent {
    ref = React.createRef();

    componentDidMount() {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    }

    checkAnswer = (event) => {
        event.preventDefault();
        this.props.dispatch(checkAnswer());
    };

    render() {
        const {question, trackId, authUrl} = this.props;

        return (
            <Fragment>
                <Title>{i18n('_AUTH_.question_title')}</Title>
                <div className={b('formHint')}>
                    <span className={b('hintQuestion')}>{question}</span>
                </div>
                <div>
                    <form method='post' action={authUrl} onSubmit={this.checkAnswer}>
                        <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                        <Field
                            size='l'
                            ref={this.ref}
                            name='hint_answer'
                            label={i18n('_AUTH_.field_hint_answer')}
                            view='big-input'
                        />
                        <div data-t='pssp:submit-check-answer-btn'>
                            <Button
                                onClick={this.checkAnswer}
                                text={i18n('_AUTH_.RestoreLogin.next-step')}
                                width='max'
                                size='l'
                            />
                        </div>
                    </form>
                </div>
            </Fragment>
        );
    }
}

QuestionInput.propTypes = {
    status: PropTypes.string,
    question: PropTypes.string.isRequired,
    trackId: PropTypes.string,
    dispatch: PropTypes.func.isRequired,
    authUrl: PropTypes.string
};
