import {connect} from 'react-redux';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getFormValues, getTrackId} from '@blocks/selectors';
import {QuestionInput} from './QuestionInput.jsx';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {status},
        common: {authUrl}
    } = state;
    const formValues = getFormValues(state);

    return {
        status,
        question: formValues.hint_question,
        trackId: getTrackId(state, TRACK_TYPES.COMMON),
        authUrl
    };
};

const ConnectedQuestionInput = connect(mapStateToProps)(QuestionInput);

export {ConnectedQuestionInput as QuestionInput};
