import React from 'react';
import {useSelector} from 'react-redux';
import {cn} from '@bem-react/classname';

import './ChildServices.styl';

const b = cn('ChildServices');

const SERVICES = [
    {
        id: 'games',
        link: 'https://yandex.%tld/games/',
        title: i18n('_AUTH_.child.services.games')
    },
    {
        id: 'kinopoisk',
        link: 'https://kinopoisk.%tld',
        title: i18n('_AUTH_.child.services.kinopoisk')
    },
    {
        id: 'music',
        link: 'https://music.yandex.%tld',
        title: i18n('_AUTH_.child.services.music')
    },
    {
        id: 'zen',
        link: 'https://zen.yandex.%tld',
        title: i18n('_AUTH_.child.services.zen')
    }
];

export function ChildServices() {
    const {tld} = useSelector(({settings}) => ({
        tld: settings.tld
    }));

    return (
        <div className={b()}>
            {SERVICES.map(({id, link, title}) => (
                <a key={id} className={b('service')} href={link.replace('%tld', tld)}>
                    <div className={b('icon', {[id]: true})} />
                    <div className={b('name')}>{title}</div>
                </a>
            ))}
        </div>
    );
}
