import React, {Component} from 'react';
import PropTypes from 'prop-types';

import CaptchaField from '../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import Form from '../Form/Form.jsx';
import errorMessages from '../../errors';

class ConfirmActualPhoneForm extends Component {
    render() {
        const {isCaptchaRequired, errors, confirmActualPhone, goToPhonesPage, goBack} = this.props;

        return (
            <Form cls='confirm-actual-phone' dataT='confirm-actual-phone'>
                {isCaptchaRequired && <CaptchaField />}

                {errors.length !== 0 && (
                    <div>
                        <p className='passp-confirm-actual-phone-form__error'>
                            {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                        </p>
                    </div>
                )}

                <div data-t='phone_actual_submit' className='passp-button'>
                    <Button
                        type='submit'
                        text={i18n('_AUTH_.phone.actual.submit')}
                        view='action'
                        size='l'
                        width='max'
                        onClick={confirmActualPhone}
                    />
                </div>

                <div data-t='phone_actual_change_phone' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.phone.actual.change-phone.v2')}
                        view='pseudo'
                        size='l'
                        width='max'
                        onClick={goToPhonesPage}
                    />
                </div>

                <div data-t='phone_actual_skip' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.phone.actual.skip')}
                        view='pseudo'
                        size='l'
                        width='max'
                        onClick={goBack}
                    />
                </div>
            </Form>
        );
    }
}

ConfirmActualPhoneForm.propTypes = {
    isCaptchaRequired: PropTypes.bool,
    errors: PropTypes.array,
    confirmActualPhone: PropTypes.func.isRequired,
    goToPhonesPage: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired
};

export default ConfirmActualPhoneForm;
