import React, {Component} from 'react';
import PropTypes from 'prop-types';

import CaptchaField from '../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import Form from '../Form/Form.jsx';
import errorMessages from '../../errors';

class ConfirmRestoreEmailForm extends Component {
    render() {
        const {isCaptchaRequired, errors, confirmRestoreEmail, goBack, goToEmailsPage} = this.props;

        return (
            <Form cls='confirm-restore-email' dataT='confirm-restore-email'>
                {isCaptchaRequired && <CaptchaField />}

                {errors.length !== 0 && (
                    <div>
                        <p className='passp-confirm-restore-email-form__error'>
                            {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                        </p>
                    </div>
                )}

                <div data-t='restore_submit' className='passp-button'>
                    <Button
                        type='submit'
                        text={i18n('_AUTH_.email.restore.submit.v2')}
                        view='action'
                        onClick={confirmRestoreEmail}
                        size='l'
                        width='max'
                    />
                </div>

                <div data-t='restore_change_email' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.email.restore.change-email')}
                        view='pseudo'
                        onClick={goToEmailsPage}
                        size='l'
                        width='max'
                    />
                </div>

                <div data-t='restore_skip' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.email.restore.skip')}
                        view='pseudo'
                        onClick={goBack}
                        size='l'
                        width='max'
                    />
                </div>
            </Form>
        );
    }
}

ConfirmRestoreEmailForm.propTypes = {
    isCaptchaRequired: PropTypes.bool,
    errors: PropTypes.array,
    confirmRestoreEmail: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    goToEmailsPage: PropTypes.func.isRequired
};

export default ConfirmRestoreEmailForm;
