import React, {Component} from 'react';
import PropTypes from 'prop-types';

import CaptchaField from '../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import Form from '../Form/Form.jsx';
import errorMessages from '../../errors';

class ConfirmSecurePhoneForm extends Component {
    render() {
        const {isCaptchaRequired, errors, sentConfirmationCode, goBack, goToPhonesPage} = this.props;

        return (
            <Form cls='confirm-secure-phone' dataT='confirm-secure-phone'>
                {isCaptchaRequired && <CaptchaField />}

                {errors.length !== 0 && (
                    <div>
                        <p className='passp-confirm-secure-phone-form__error'>
                            {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                        </p>
                    </div>
                )}

                <div data-t='phone_secure_submit' className='passp-button'>
                    <Button
                        type='submit'
                        text={i18n('_AUTH_.phone.secure.submit')}
                        view='action'
                        size='l'
                        width='max'
                        onClick={sentConfirmationCode}
                    />
                </div>

                <div data-t='phone_secure_skip' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.phone.secure.skip')}
                        view='pseudo'
                        size='l'
                        width='max'
                        onClick={goBack}
                    />
                </div>

                <div data-t='phone_secure_change_phone' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.phone.secure.change-phone')}
                        view='pseudo'
                        size='l'
                        width='max'
                        onClick={goToPhonesPage}
                    />
                </div>
            </Form>
        );
    }
}

ConfirmSecurePhoneForm.propTypes = {
    isCaptchaRequired: PropTypes.bool,
    errors: PropTypes.array,
    sentConfirmationCode: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    goToPhonesPage: PropTypes.func.isRequired
};

export default ConfirmSecurePhoneForm;
