import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {push} from 'connected-react-router';
import {updateLoginValue} from '../../actions';
import changeNativeInputValue from '../../actions/changeNativeInputValue';
import mapStateToProps from './mapStateToProps';

const b = cn('CurrentAccount');

class CurrentAccount extends Component {
    switchToListPage = (event) => {
        event.preventDefault();

        const {addUserUrl, editUrl, hasUnitedAccounts, dispatch} = this.props;

        dispatch(push(hasUnitedAccounts ? editUrl : addUserUrl, {isPreviousStep: true}));

        if (!hasUnitedAccounts) {
            dispatch(updateLoginValue(''));
            dispatch(changeNativeInputValue('login', ''));
        }
    };

    render() {
        const {
            hasDisplayName,
            displayLogin,
            avatarStyle,
            displayName,
            login,
            editUrl,
            account,
            clickDisabled
        } = this.props;

        if (!account) {
            return null;
        }

        if (clickDisabled) {
            return (
                <div className={b('', {clickDisabled})}>
                    <span className={b('avatar')} style={avatarStyle} />
                    <span className={b('name')}>
                        <span className={b('displayName')}>{displayName || displayLogin || login}</span>
                        {hasDisplayName && displayLogin && <span className={b('login')}>{displayLogin}</span>}
                    </span>
                </div>
            );
        }

        return (
            <a className={b()} href={editUrl} onClick={this.switchToListPage}>
                <span className={b('avatar')} style={avatarStyle} />
                <span className={b('name')}>
                    <span className={b('displayName')}>{displayName || displayLogin || login}</span>
                    {hasDisplayName && displayLogin && <span className={b('login')}>{displayLogin}</span>}
                </span>
            </a>
        );
    }
}

CurrentAccount.propTypes = {
    account: PropTypes.object,
    clickDisabled: PropTypes.bool,
    hasDisplayName: PropTypes.bool.isRequired,
    displayLogin: PropTypes.string,
    avatarStyle: PropTypes.object.isRequired,
    displayName: PropTypes.string,
    login: PropTypes.string,
    addUserUrl: PropTypes.string.isRequired,
    editUrl: PropTypes.string.isRequired,
    hasUnitedAccounts: PropTypes.bool.isRequired,
    dispatch: PropTypes.func.isRequired
};

export default connect(mapStateToProps)(CurrentAccount);
