import socialAliases from '../../social_aliases';

export default function mapStateToProps(state) {
    const {
        common: {editUrl, addUserUrl},
        settings: {avatar: avatarSettings},
        auth: {processedAccount: account, unitedAccounts = {}}
    } = state;
    const {avatarId, login, displayName, hasSocial, mail, defaultEmail, socialProvider} = account || {};
    const {host, pathname} = avatarSettings;
    const hasDisplayName = Boolean(displayName);
    const avatarPathname = pathname
        .replace('%uid%', avatarId)
        .replace('%size%', '200')
        .replace('%login%', login);
    const avatarStyle = {backgroundImage: `url("https://${host}${avatarPathname}")`};
    const displayLogin = hasSocial ? socialAliases[socialProvider] : mail || defaultEmail || '';
    const hasUnitedAccounts = Object.keys(unitedAccounts).length > 0;

    return {
        hasDisplayName,
        displayLogin,
        avatarStyle,
        displayName,
        login,
        addUserUrl,
        editUrl,
        hasUnitedAccounts,
        account
    };
}
