import './DomikFooterLink.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Link} from '@components/Link';

const b = cn('DomikFooterLink');

export const DomikFooterLink = ({href, onClick, target = '_self', dataT, pseudo, children}) => (
    <div className={b()}>
        <Link
            dataT={dataT || 'footer-link'}
            id={dataT || undefined}
            weight='medium'
            href={href}
            onClick={onClick}
            target={target}
            pseudo={pseudo}
        >
            {children}
        </Link>
    </div>
);

DomikFooterLink.propTypes = {
    href: PropTypes.string,
    onClick: PropTypes.func,
    target: PropTypes.string,
    children: PropTypes.node,
    dataT: PropTypes.string,
    pseudo: PropTypes.bool
};
