import React, {Component} from 'react';
import PropTypes from 'prop-types';

import {Field} from '@components/Field';
import CaptchaField from '../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import Form from '../Form/Form.jsx';
import errorMessages from '../../errors';

class EnterEmailForm extends Component {
    render() {
        const {email, isCaptchaRequired, errors, handleEmailChange, sentConfirmationCode, goBack, action} = this.props;

        let fieldError = null;

        if (errors.length) {
            fieldError = errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal;
        }

        return (
            <Form cls='enter-email' dataT='enter-email'>
                <Field
                    size='l'
                    label={i18n('_AUTH_.email.enter-email.label.v2')}
                    value={email}
                    name='additional_email'
                    type='text'
                    error={fieldError}
                    onChange={handleEmailChange}
                    view='big-input'
                />

                {isCaptchaRequired && <CaptchaField />}

                <div data-t='email_submit' className='passp-button'>
                    <Button
                        type='submit'
                        text={
                            action === 'add'
                                ? i18n('_AUTH_.email.add-email.submit')
                                : i18n('_AUTH_.email.enter-email.submit')
                        }
                        view='action'
                        onClick={sentConfirmationCode}
                        size='l'
                        width='max'
                    />
                </div>

                <div data-t='email_skip' className='passp-button'>
                    <Button
                        type='button'
                        text={i18n('_AUTH_.email.enter-email.skip')}
                        view='pseudo'
                        onClick={goBack}
                        size='l'
                        width='max'
                    />
                </div>
            </Form>
        );
    }
}

EnterEmailForm.propTypes = {
    email: PropTypes.string,
    isCaptchaRequired: PropTypes.bool,
    errors: PropTypes.array,
    handleEmailChange: PropTypes.func.isRequired,
    sentConfirmationCode: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    action: PropTypes.string.isRequired
};

export default EnterEmailForm;
