import React, {Component} from 'react';
import PropTypes from 'prop-types';

import {Field} from '@components/Field';
import CaptchaField from '../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import Form from '../Form/Form.jsx';
import errorMessages from '../../errors';

class EnterPhoneForm extends Component {
    ref = React.createRef();

    componentDidMount() {
        this.ref && this.ref.current && this.ref.current.focus();
    }

    render() {
        const {
            isCaptchaRequired,
            phoneNumber,
            handlePhoneChange,
            errors = [],
            sentConfirmationCode,
            goBack,
            action
        } = this.props;

        let fieldError = null;

        if (errors.length > 0) {
            fieldError = errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal;
        }

        return (
            <Form cls='enter-phone' dataT='enter-phone'>
                <Field
                    size='l'
                    label={i18n('_AUTH_.phone.enter-phone.label.v2')}
                    value={phoneNumber}
                    name='phoneNumber'
                    type='text'
                    error={fieldError}
                    onChange={handlePhoneChange}
                    view='big-input'
                    ref={this.ref}
                />

                {isCaptchaRequired && <CaptchaField />}

                <div data-t='phone_submit' className='passp-button'>
                    <Button
                        type='submit'
                        text={
                            action === 'add'
                                ? i18n('_AUTH_.phone.enter-phone.submit')
                                : i18n('_AUTH_.phone.enter-confirmation-code.submit')
                        }
                        view='action'
                        width='max'
                        size='l'
                        onClick={sentConfirmationCode}
                    />
                </div>

                {goBack && (
                    <div data-t='phone_skip' className='passp-button'>
                        <Button
                            type='button'
                            text={i18n('_AUTH_.phone.enter-phone.skip')}
                            view='pseudo'
                            width='max'
                            size='l'
                            onClick={goBack}
                        />
                    </div>
                )}
            </Form>
        );
    }
}

EnterPhoneForm.propTypes = {
    isCaptchaRequired: PropTypes.bool.isRequired,
    phoneNumber: PropTypes.string.isRequired,
    handlePhoneChange: PropTypes.func.isRequired,
    errors: PropTypes.array.isRequired,
    sentConfirmationCode: PropTypes.func.isRequired,
    goBack: PropTypes.func,
    action: PropTypes.string.isRequired
};

export default EnterPhoneForm;
