import {isMobile} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        settings: {tld, env, help, language, langlist},
        common: {isWebView}
    } = state;

    const currentYear = new Date().getFullYear();

    let domain = tld;

    if (['az', 'com.am', 'com.ge', 'kg', 'md', 'tj', 'tm', 'uz'].indexOf(domain) > -1) {
        domain = 'ru';
    } else if (['co.il', 'fr', 'lv', 'lt', 'ee', 'fi', 'pl', 'eu'].indexOf(domain) > -1) {
        domain = 'com';
    }

    let options;

    if (!langlist || env.name === 'intranet') {
        options = [];
    } else {
        options = langlist
            .filter((item) => item.id !== language)
            .map((item) => ({
                text: item.name,
                url: item.link
            }));
    }

    const helpLink = ((help || {}).passport || '#').replace('%tld%', domain);
    const isIntranet = env.name === 'intranet';
    const hasSwitcher = tld !== 'com' && !isIntranet && options.length > 0;

    return {
        tld,
        lang: language,
        options,
        helpLink,
        currentYear,
        hasSwitcher,
        isWebView,
        isMobile: isMobile(state)
    };
}
