import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('PasspAuthForm');

const defaultSubmit = (event) => {
    event.preventDefault();
};

const Form = ({children, onSubmit, withoutOffset, method = 'post', dataT, action}) => (
    <form
        method={method}
        onSubmit={onSubmit || defaultSubmit}
        className={b({withoutOffset})}
        data-t={dataT ? `page:form:${dataT}` : 'page:form'}
        action={action}
    >
        {children}
    </form>
);

Form.propTypes = {
    method: PropTypes.string,
    dataT: PropTypes.string,
    action: PropTypes.string,
    children: PropTypes.node.isRequired,
    onSubmit: PropTypes.func,
    withoutOffset: PropTypes.bool
};

export default Form;
