import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Logo} from '@components/Logo';
import {LoginLogoId} from '@components/LoginLogoId';

import './Header.styl';

const b = cn('Header');

export const Header = ({isAvailable, whitelabelLogo, fullscreenLogo, isAvatarLogoId}) => {
    if (!isAvailable) {
        return null;
    }

    if (isAvatarLogoId) {
        return <LoginLogoId />;
    }

    return (
        <div className={b()}>
            <div className={b('yaLogoBlock')}>
                <Logo whitelabelLogo={whitelabelLogo} fullscreenLogo={fullscreenLogo} />
            </div>
        </div>
    );
};

Header.propTypes = {
    serviceLogo: PropTypes.string,
    logoType: PropTypes.string,
    whitelabelLogo: PropTypes.object,
    fullscreenLogo: PropTypes.object,
    isAvailable: PropTypes.bool,
    isAvatarLogoId: PropTypes.bool,
    isServiceLogoAvailable: PropTypes.bool,
    isRuLogo: PropTypes.bool
};
