import {connect} from 'react-redux';
import {isKeyEnabled2FASelector} from '@blocks/selectors';
import {Header} from './Header.jsx';

const mapStateToProps = (state = {}) => {
    const {customs = {}, auth = {}, settings = {}, router: {location = {}} = {}} = state;
    const {theme} = settings;
    const {whitelabel: {logo, darkThemeLogo} = {}, fullscreen: {logo: fullscreenLogo} = {}} = customs;
    const {mode} = auth;

    const whitelabelLogo = theme === 'dark' && darkThemeLogo ? darkThemeLogo : logo;

    return {
        isAvailable: !['magic', 'customLogo', 'childish'].includes(mode) && location.pathname !== '/auth/precomplete',
        isAvatarLogoId: isKeyEnabled2FASelector(state),
        fullscreenLogo,
        whitelabelLogo
    };
};

const ConnectedHeader = connect(mapStateToProps)(Header);

export {ConnectedHeader as Header};
