import React, {useEffect} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import classnames from 'classnames';
import PageOverlay from '../PageOverlay/PageOverlay.jsx';
import {PreviousStepButton} from '../PreviousStepButton';
import {AuthWebviewCloser} from '../AuthWebviewCloser';
import {PagePopup} from '../PagePopup';
import {Header} from './Header';
import Footer from '../Footer/Footer.jsx';
import {CustomsBackground} from '@components/CustomsBackground';
import broker from '@blocks/authv2/broker';
import {NoJS} from '@components/NoJS';
import {AM_OPEN_DEBUG_PAGE_CLICKS_COUNT} from '@blocks/authv2/nativeMobileApi';
import {formatLocTextWithLink} from '@blocks/authv2/utils/formatLocTextWithLink';
import {MagicBookPage} from '@blocks/authv2/components/MagicBookPage';
import {PageHeaderLogo} from '@yandex-id/components/components/Logo';
import {Link} from 'react-router-dom';
import './Layout.styl';

const b = cn('Layout');

const PromoText = ({isFamilyPromoExp, isWebView, isWhiteLabel, hideYaIdPromo, tld = 'ru'}) => {
    const showPromo = !isWebView && !isWhiteLabel && !hideYaIdPromo;

    if (showPromo) {
        if (isFamilyPromoExp) {
            return (
                <div
                    className='yaIdPromoText'
                    dangerouslySetInnerHTML={{
                        __html: formatLocTextWithLink(
                            i18n('_AUTH_.family.promo_text'),
                            ` https://id.yandex.${tld === 'ru' ? tld : 'com'}/yafamily?origin=yandexid_auth_form`,
                            'yaIdPromoText_link'
                        )
                    }}
                />
            );
        }

        return (
            <div
                className='yaIdPromoText'
                dangerouslySetInnerHTML={{
                    __html: formatLocTextWithLink(
                        i18n('_AUTH_.ya.id.promo_text'),
                        `https://id.yandex.${tld}/about`,
                        'yaIdPromoText_link'
                    )
                }}
            />
        );
    }
    return null;
};

export const Layout = ({
    bookQREnabled,
    language,
    minimal,
    hideYaIdPromo,
    isShowPagePopup,
    isAM,
    isWhiteLabel,
    isFullScreen,
    isWebView,
    isNativeAm,
    children,
    isShowBG,
    isChallenge,
    isMobile,
    onOpenDebugPage,
    tld,
    isFamilyPromoExp,
    hasRegCompleteStepBack,
    onRegCompleteStepBack
}) => {
    const authContentRef = React.useRef(null);
    const authContentClicksCount = React.useRef(0);
    const showPreviousStepButton = isNativeAm || !isChallenge || hasRegCompleteStepBack;

    useEffect(() => {
        if (broker.getStore()) {
            broker.maybeEmitEventWithDataFromStorage();
        }
    }, []);

    useEffect(() => {
        if (!isNativeAm) {
            return;
        }

        const windowClickListener = (event) => {
            if (event.target === authContentRef.current) {
                authContentClicksCount.current = authContentClicksCount.current + 1;
            } else {
                authContentClicksCount.current = 0;
            }

            if (authContentClicksCount.current >= AM_OPEN_DEBUG_PAGE_CLICKS_COUNT) {
                onOpenDebugPage();
            }
        };

        window.addEventListener('click', windowClickListener);

        return () => {
            window.removeEventListener('click', windowClickListener);
        };
    }, [authContentRef, authContentClicksCount, isNativeAm, onOpenDebugPage]);

    return (
        <div
            className={classnames('passp-flex-wrapper', {
                'passp-flex-wrapper_isAm': isNativeAm,
                'passp-flex-wrapper_isFullScreen': isFullScreen
            })}
        >
            <NoJS isFloat={!isMobile} />
            <div
                className={classnames('passp-page', {
                    'passp-page_minimal': minimal
                })}
            >
                {isShowBG && <CustomsBackground />}

                <div className='passp-flex-wrapper'>
                    <div className={classnames('passp-content', {'Layout-content_bookQR': bookQREnabled})}>
                        <div className={classnames('passp-auth', {'passp-auth_bookQR': bookQREnabled})}>
                            <PageOverlay />

                            {isShowPagePopup ? (
                                <PagePopup />
                            ) : (
                                <>
                                    {showPreviousStepButton && (
                                        <PreviousStepButton
                                            onStepBack={hasRegCompleteStepBack ? onRegCompleteStepBack : undefined}
                                        />
                                    )}

                                    <AuthWebviewCloser />

                                    {bookQREnabled ? (
                                        <div className={b('book')}>
                                            <MagicBookPage className={b('qr')} />
                                            <div className='passp-auth-content' ref={authContentRef}>
                                                <PageHeaderLogo
                                                    tld={tld}
                                                    lang={language}
                                                    isProfile={false}
                                                    linkComponent={Link}
                                                />
                                                {children}
                                            </div>
                                        </div>
                                    ) : (
                                        <div className='passp-auth-content' ref={authContentRef}>
                                            <Header />
                                            {children}
                                            {isFullScreen && (
                                                <div className={b('fullscreenLogo')}>
                                                    <PageHeaderLogo
                                                        tld={tld}
                                                        lang={language}
                                                        isProfile={false}
                                                        linkComponent={Link}
                                                    />
                                                </div>
                                            )}
                                        </div>
                                    )}
                                </>
                            )}

                            <PromoText
                                isFamilyPromoExp={isFamilyPromoExp}
                                isWebView={isWebView}
                                isWhiteLabel={isWhiteLabel}
                                hideYaIdPromo={hideYaIdPromo}
                                tld={tld}
                            />
                        </div>
                    </div>
                </div>

                {!isAM && !isNativeAm && !isWhiteLabel && !isFullScreen && <Footer />}
            </div>
        </div>
    );
};

Layout.propTypes = {
    bookQREnabled: PropTypes.bool,
    isShowPagePopup: PropTypes.bool,
    isShowBG: PropTypes.bool,
    isChallenge: PropTypes.bool,
    language: PropTypes.string,
    minimal: PropTypes.bool,
    children: PropTypes.node.isRequired,
    hideYaIdPromo: PropTypes.bool,
    isAM: PropTypes.bool,
    isWhiteLabel: PropTypes.bool,
    isFullScreen: PropTypes.bool,
    isNativeAm: PropTypes.bool,
    isMobile: PropTypes.bool,
    isWebView: PropTypes.bool,
    onOpenDebugPage: PropTypes.func.isRequired,
    hasRegCompleteStepBack: PropTypes.bool,
    onRegCompleteStepBack: PropTypes.func,
    tld: PropTypes.string,
    isFamilyPromoExp: PropTypes.bool
};

PromoText.propTypes = {
    isFamilyPromoExp: PropTypes.bool,
    isWebView: PropTypes.bool,
    isWhiteLabel: PropTypes.bool,
    hideYaIdPromo: PropTypes.bool,
    tld: PropTypes.string.isRequired
};
