import {connect} from 'react-redux';
import {hasExp, isBookQREnabled} from '@blocks/selectors';
import {Layout} from './Layout.jsx';
import {openDebugPage} from '@blocks/authv2/actions/nativeMobileApi';
import {onBack} from '@blocks/AuthRegComplete/actions';

const mapStateToProps = (state = {}) => {
    const {
        pagePopup: {isShowPagePopup},
        common: {pane, isWebView, isAM},
        settings: {
            ua: {isMobile, isTablet},
            language,
            tld
        },
        customs: {minimal},
        router = {},
        customs: {isWhiteLabel = false, isFullScreen = false, hideYaIdPromo = false},
        am = {}
    } = state;
    const {location = {}} = router;

    return {
        isMobile,
        isTablet,
        language,
        minimal,
        isShowPagePopup,
        pane,
        hideYaIdPromo,
        isWebView,
        isAM,
        isWhiteLabel,
        isFullScreen,
        isNativeAm: am.isAm,
        isShowBG: isTablet || !isMobile,
        isChallenge: location.pathname === '/auth/challenge',
        bookQREnabled: isBookQREnabled(state),
        tld,
        isFamilyPromoExp: hasExp(state, 'family-promo-exp'),
        hasRegCompleteStepBack:
            state.completeFlow && state.completeFlow.breadcrumbs && Boolean(state.completeFlow.breadcrumbs.length)
    };
};

const mapDispatchToProps = (dispatch) => {
    return {
        onOpenDebugPage() {
            dispatch(openDebugPage());
        },
        onRegCompleteStepBack() {
            dispatch(onBack());
        }
    };
};

const ConnectedLayout = connect(mapStateToProps, mapDispatchToProps)(Layout);

export {ConnectedLayout as Layout};
