import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import mapStateToProps from './mapStateToProps';

import {Field} from '@components/Field';
import switchToModeRestoreLogin from '../../actions/switchToModeRestoreLogin';

class LoginField extends Component {
    constructor(props) {
        super(props);

        this.fieldOptions = {
            autoCorrect: 'off',
            autoCapitalize: 'off',
            autoComplete: 'username'
        };

        const {fieldLink, dispatch} = props;

        this.fieldLink = Object.assign({}, fieldLink);
        this.fieldLink.onClick = () => {
            fieldLink.onClick();
            dispatch(switchToModeRestoreLogin());
        };
    }

    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        const {isNoTabletTouch} = this.props;

        if (isNoTabletTouch) {
            return;
        }

        setTimeout(this.focus, 300);
    }

    render() {
        const {
            login,
            placeholder,
            onChangeLogin,
            fieldError,
            fieldLabel,
            fieldType,
            accountDisabledFieldLink,
            isShowFieldLink,
            isAccountDisabledStatus,
            skipLabel,
            skipLink,
            customPlaceholder
        } = this.props;

        return (
            <Field
                size='l'
                ref={this.ref}
                label={skipLabel ? null : fieldLabel}
                hideLabel={skipLabel}
                value={login}
                name='login'
                type={fieldType || 'text'}
                placeholder={customPlaceholder || placeholder}
                error={fieldError}
                link={skipLink ? null : isAccountDisabledStatus ? accountDisabledFieldLink : this.fieldLink}
                options={this.fieldOptions}
                isShowFieldLink={isShowFieldLink}
                onChange={onChangeLogin}
                view='big-input'
            />
        );
    }
}

LoginField.defaultProps = {
    fieldValue: ''
};

LoginField.propTypes = {
    login: PropTypes.string.isRequired,
    onChangeLogin: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired,
    fieldLink: PropTypes.shape({
        url: PropTypes.string.isRequired,
        text: PropTypes.string.isRequired,
        onClick: PropTypes.func.isRequired
    }).isRequired,
    fieldError: PropTypes.string.isRequired,
    fieldLabel: PropTypes.string.isRequired,
    fieldType: PropTypes.string,
    placeholder: PropTypes.string.isRequired,
    accountDisabledFieldLink: PropTypes.object,
    isAccountDisabledStatus: PropTypes.bool,
    isShowFieldLink: PropTypes.bool.isRequired,
    isNoTabletTouch: PropTypes.bool.isRequired,
    skipLabel: PropTypes.bool,
    skipLink: PropTypes.bool,
    customPlaceholder: PropTypes.string
};

export default connect(mapStateToProps)(LoginField);
