import errors from '../../errors';
import {SHOW_LOGIN_FORM, CLICK_RESTORE_ACCESS_LINK} from '../../metrics_constants';
import metrics from '../../../metrics';
import trimLastDot from '../../utils/trimLastDot';

const HELP_FOR_BLOCKED_LINK = 'https://yandex.%tld/support/passport/troubleshooting/blocked.html';

const YA_ID_TYPE_LABEL_TEXTS = {
    email: i18n('_AUTH_.enter_login_title.email'),
    login: i18n('_AUTH_.enter_login_title.login'),
    phone: i18n('_AUTH_.enter_login_title.phone')
};

export default function mapStateToProps(state) {
    const {
        settings: {isNoTabletTouch, tld, ua},
        common: {restoreLoginUrl, restoration_url: restorationUrl},
        auth: {loginError, isDefaultTextsExp, isAbleToRestore, form},
        customs: {
            isWhiteLabel = false,
            isEmailOnly = false,
            yaIdType = null,
            hideForgetLoginLink = false,
            hideForgetLoginLinkUntilShowLoginError = false
        } = {}
    } = state;

    const fieldLink = {
        url: restoreLoginUrl,
        text: i18n('_AUTH_.restore_id_link'),
        pseudo: true,
        onClick: () => {
            metrics.send([SHOW_LOGIN_FORM, CLICK_RESTORE_ACCESS_LINK]);
        }
    };
    const {login} = form;
    const accountDisabledFieldLink = {
        url: isAbleToRestore
            ? restorationUrl.replace('login=login', login ? `login=${login}` : '')
            : HELP_FOR_BLOCKED_LINK.replace('%tld', tld),
        text: isAbleToRestore ? i18n('_AUTH_.restore_access') : i18n('_AUTH_.auth.ask_support'),
        onClick: () => {
            metrics.send([SHOW_LOGIN_FORM, CLICK_RESTORE_ACCESS_LINK]);
        }
    };
    const fieldError = processLoginError(loginError);
    const isAccountDisabledStatus = loginError === 'account.disabled_on_deletion';
    const isIE = ua.BrowserName === 'MSIE';

    let isShowFieldLink =
        !fieldError ||
        (fieldError !== errors.global &&
            ['captcha.required', 'csrf_token.invalid', 'account.disabled', 'sessionid.overflow'].indexOf(loginError) ===
                -1);

    let fieldLabel = i18n('_AUTH_.login_id.label');

    if (isIE || isDefaultTextsExp) {
        fieldLabel = i18n('_AUTH_.enter_login_title.v2');
    }

    // Выпилить после выкладки yaIdType в прод
    if (isEmailOnly) {
        fieldLabel = i18n('_AUTH_.enter_login_title.email');
        isShowFieldLink = false;
    }

    let placeholder = '';

    if (!isWhiteLabel) {
        placeholder = i18n('_AUTH_.login_id_placeholder');
    }

    if (yaIdType && YA_ID_TYPE_LABEL_TEXTS[yaIdType]) {
        fieldLabel = YA_ID_TYPE_LABEL_TEXTS[yaIdType];
        placeholder = '';
        isShowFieldLink = false;
    }

    if (hideForgetLoginLink || (hideForgetLoginLinkUntilShowLoginError && !loginError)) {
        isShowFieldLink = false;
    }

    return {
        isNoTabletTouch,
        fieldLink,
        accountDisabledFieldLink,
        fieldError,
        isShowFieldLink,
        isAccountDisabledStatus,
        fieldLabel,
        loginError,
        placeholder
    };
}

export function processLoginError(loginError) {
    if (!loginError) {
        return '';
    }

    if (loginError === 'captcha.required') {
        return '';
    }

    return trimLastDot(errors[loginError] || errors.global);
}
