import {bindActionCreators} from 'redux';

import switchToModeRegisterLite from '../../actions/switchToModeRegisterLite';
import switchToModeRegister from '../../actions/switchToModeRegister';
import {updateLoginValue, updatePasswordValue, setupBackPane, canRegister, setLoginError} from '../../actions';
import {amOnLoginFormMount} from '../../actions/multiStepAuthStart';

export default function mapDispatchToProps(dispatch) {
    const actionCreators = {
        updateLoginValue,
        updatePasswordValue,
        setupBackPane,
        canRegister,
        setLoginError,
        switchToModeRegisterLite,
        switchToModeRegister,
        onMount: amOnLoginFormMount
    };

    return Object.assign({}, bindActionCreators(actionCreators, dispatch), {dispatch});
}
