import formatRegistrationUrl from '../../utils/formatRegistrationUrl';
import {isNeoPhonishRegisterAvailable, hasExp, getFormValues} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        auth: {
            form: {
                login,
                isCanRegister,
                registrationLogin,
                registrationType,
                registrationPhoneNumber,
                registrationCountry
            },
            loginError,
            mode,
            loading,
            isPreRegisterExp,
            isRegisterWithSuggestToRestoreByPhoneInDaHouse
        },
        common: {
            registration_url: registrationExpUrl,
            registration_url_with_params: registrationUrlWithParams,
            retpath,
            fretpath,
            clean,
            csrf,
            addUserUrl,
            backPane,
            authUrl,
            liteRegisterUrl
        },
        am: {isAm, isAuthBySWC, suggestedLoginFromSWC} = {},
        customs: {hideAuthLoginInputToggle = false}
    } = state;
    const phoneNumber = getFormValues(state).phone;

    let baseRegistrationUrl = registrationUrlWithParams;

    if (registrationType !== 'portal') {
        baseRegistrationUrl = liteRegisterUrl;
    }

    const registrationUrl = formatRegistrationUrl(
        baseRegistrationUrl,
        registrationLogin,
        registrationPhoneNumber,
        registrationCountry
    );
    const hasCaptcha = Boolean(loginError && loginError.indexOf('captcha') > -1);

    return {
        registrationUrl,
        registrationExpUrl,
        registrationType,
        login,
        phoneNumber,
        retpath,
        fretpath,
        clean,
        csrf,
        addUserUrl,
        backPane,
        isCanRegister,
        registrationLogin,
        hasCaptcha,
        authUrl,
        mode,
        loading,
        isPreRegisterExp,
        isRegisterWithSuggestToRestoreByPhoneInDaHouse,
        isAm,
        isAuthBySWC,
        suggestedLoginFromSWC,
        isNeoPhonishRegisterExp: isNeoPhonishRegisterAvailable(state),
        isToggleInputExp:
            !hideAuthLoginInputToggle &&
            (hasExp(state, 'auth-toggle-input-exp') || hasExp(state, 'auth-toggle-login-phone-exp'))
    };
}
