import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {SHOW_LOGIN_FORM, CLICK_EXPERIMENT_REGISTER_BUTTON} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';

class LoginFormRegisterButton extends React.Component {
    sendMetrics = () => metrics.send([SHOW_LOGIN_FORM, CLICK_EXPERIMENT_REGISTER_BUTTON]);

    onClick = (event) => {
        const {
            isRegisterWithSuggestToRestoreByPhoneInDaHouseExp,
            isNeoPhonishRegisterExp,
            isAmCustomRegType,
            switchToModeRegister
        } = this.props;

        this.sendMetrics();

        if (isRegisterWithSuggestToRestoreByPhoneInDaHouseExp || isNeoPhonishRegisterExp || isAmCustomRegType) {
            event.preventDefault();
            switchToModeRegister();
        }
    };

    render() {
        const {url, hideRegButton} = this.props;
        const elemId = 'passp:exp-register';

        if (hideRegButton) {
            return null;
        }

        return (
            <div className='passp-button passp-exp-register-button'>
                <Button
                    type='link'
                    dataT={elemId}
                    id={elemId}
                    url={url}
                    text={i18n('_AUTH_.register_id')}
                    view='pseudo'
                    onClick={this.onClick}
                    size='l'
                    width='max'
                />
            </div>
        );
    }
}

LoginFormRegisterButton.propTypes = {
    url: PropTypes.string.isRequired,
    hideRegButton: PropTypes.bool,
    isRegisterWithSuggestToRestoreByPhoneInDaHouseExp: PropTypes.bool.isRequired,
    isNeoPhonishRegisterExp: PropTypes.bool.isRequired,
    isAmCustomRegType: PropTypes.bool,
    switchToModeRegister: PropTypes.func.isRequired
};

export {LoginFormRegisterButton};
