import {connect} from 'react-redux';
import {LoginFormRegisterButton} from './LoginFormRegisterButton.jsx';
import switchToModeRegister from '@blocks/authv2/actions/switchToModeRegister';
import {isNeoPhonishRegisterAvailable} from '@blocks/selectors';
import {RegType} from '@blocks/authv2/nativeMobileApi';

const mapStateToProps = (state = {}) => {
    const {
        auth: {isRegisterWithSuggestToRestoreByPhoneInDaHouse, loginError} = {},
        am = {},
        customs: {hideRegButton = false, hideRegButtonUntilShowLoginError = false} = {}
    } = state;

    return {
        hideRegButton: hideRegButton || (hideRegButtonUntilShowLoginError && !loginError),
        isRegisterWithSuggestToRestoreByPhoneInDaHouseExp: isRegisterWithSuggestToRestoreByPhoneInDaHouse,
        isNeoPhonishRegisterExp: isNeoPhonishRegisterAvailable(state),
        isAmCustomRegType:
            am.isAm &&
            Object.keys(RegType)
                .map((key) => RegType[key])
                .includes(am.regType)
    };
};

const mapDispatchToProps = {
    switchToModeRegister
};

const ConnectedLoginFormRegisterButton = connect(mapStateToProps, mapDispatchToProps)(LoginFormRegisterButton);

export {ConnectedLoginFormRegisterButton as LoginFormRegisterButton};
