import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {IdLogoShortIcon} from '@blocks/Components/IdLogoShortIcon';
import './MagicAvatar.styl';

const b = cn('MagicAvatar');

export class MagicAvatar extends PureComponent {
    static propTypes = {
        avatarImageUrl: PropTypes.string,
        publicDisplayName: PropTypes.string
    };

    state = {
        show: false,
        gradientStateEnd: false
    };

    componentDidMount() {
        setTimeout(() => {
            this.setState({show: true});
            setTimeout(() => {
                this.setState({gradientStateEnd: true});
            }, 1200);
        }, 300);
    }

    render() {
        const {avatarImageUrl, publicDisplayName} = this.props;
        const {show, gradientStateEnd} = this.state;

        return (
            <div className={b('', {show})}>
                <div
                    className={b('gradientAvatar', {
                        complete: gradientStateEnd
                    })}
                />
                {avatarImageUrl ? (
                    <div className={b('avatar')} style={{backgroundImage: avatarImageUrl}} />
                ) : (
                    <IdLogoShortIcon className={b('avatar')} />
                )}
                <div className={b('name')}>
                    <span>{i18n('_AUTH_.auth.turbo-login-welcome')}</span>
                    {publicDisplayName && (
                        <>
                            <span>,</span>
                            <br />
                            <span>{publicDisplayName}</span>
                        </>
                    )}
                </div>
            </div>
        );
    }
}
