export function mapStateToProps(state) {
    const {
        settings: {avatar: avatarSettings},
        auth: {processedAccount, defaultAccount}
    } = state;
    const account = processedAccount || defaultAccount;
    const {avatarId, login, publicDisplayName, name, displayName} = account || {};
    const {host, pathname} = avatarSettings;

    let avatarImageUrl;

    if (!avatarId || avatarId !== '0/0-0') {
        const avatarPathname = pathname
            .replace('%uid%', avatarId)
            .replace('%size%', '200')
            .replace('%login%', login);

        avatarImageUrl = `url("https://${host}${avatarPathname}")`;
    }

    return {
        avatarImageUrl,
        publicDisplayName: publicDisplayName || name || displayName
    };
}
