import React from 'react';
import PropTypes from 'prop-types';
import MagicField from '@blocks/authv2/components/MagicField/MagicField.jsx';
import {cn} from '@bem-react/classname';
import {Captcha} from '@screens/Captcha';
import './MagicBookPage.styl';
import {SHOW_AUTH_MAGIC_BOOK_PAGE} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';

const b = cn('MagicBookPage');

export class MagicBookPage extends React.PureComponent {
    static propTypes = {
        updateMagicTokens: PropTypes.func.isRequired,
        isCaptchaRequired: PropTypes.bool,
        magicInit: PropTypes.func.isRequired,
        magicRestart: PropTypes.func.isRequired,
        magicStop: PropTypes.func.isRequired,
        captchaStart: PropTypes.func.isRequired,
        onCaptchaCheck: PropTypes.func.isRequired,
        trackId: PropTypes.string,
        csrfToken: PropTypes.string,
        className: PropTypes.string,
        fieldError: PropTypes.string,
        magicIcon: PropTypes.string
    };

    componentDidMount() {
        const {updateMagicTokens, csrfToken, trackId, fieldError} = this.props;

        metrics.send([SHOW_AUTH_MAGIC_BOOK_PAGE]);

        if (!fieldError && csrfToken && trackId) {
            this._restartMagic();
        } else {
            updateMagicTokens();
        }
    }

    _restartMagic() {
        this.props.magicInit();
    }

    _onCaptchaCheck = () => {
        this.props.onCaptchaCheck();
        this._restartMagic();
    };

    componentDidUpdate(prevProps) {
        if (prevProps.csrfToken !== this.props.csrfToken || prevProps.trackId !== this.props.trackId) {
            this._restartMagic();
        }
    }

    componentWillUnmount() {
        this.props.magicStop();
    }

    render() {
        const {className, trackId, fieldError, magicIcon, isCaptchaRequired} = this.props;

        return (
            <div className={b('', [className])}>
                {isCaptchaRequired ? (
                    <Captcha onConfirmCallback={this._onCaptchaCheck} />
                ) : (
                    <>
                        <MagicField trackId={trackId} icon={magicIcon} className={b('magicField')} />
                        {Boolean(fieldError) && (
                            <div className={b('error')} dangerouslySetInnerHTML={{__html: fieldError}} />
                        )}
                        <div className={b('text')}>
                            <span className={b('title')}>{i18n('_AUTH_.AuthBookQR.title')}</span>
                            <span className={b('description')}>{i18n('_AUTH_.AuthBookQR.description')}</span>
                        </div>
                    </>
                )}
            </div>
        );
    }
}
