import {magicService} from '@blocks/AuthSilent/magicService';
import {changeCaptchaState} from '@blocks/authv2/actions';
import {magicInit, updateMagicTokens} from '@blocks/authv2/actions/magic';
import {setCaptchaTrack} from '@components/Captcha/actions';

export function mapDispatchToProps(dispatch) {
    return {
        magicInit: () => {
            dispatch(magicInit());
        },
        magicRestart: () => {
            magicService.restart();
        },
        magicStop: () => {
            magicService.stop();
        },
        captchaStart: () => {
            dispatch((dispatch, getState) => {
                const {
                    auth: {magicTrack: trackId}
                } = getState();

                magicService.stop();
                dispatch(setCaptchaTrack(trackId));
                dispatch(changeCaptchaState(true));
            });
        },
        onCaptchaCheck: () => {
            dispatch(changeCaptchaState(false));
        },
        updateMagicTokens: () => {
            dispatch(updateMagicTokens());
        }
    };
}
