import errors from '@blocks/authv2/errors';

export function mapStateToProps(state) {
    const {
        auth: {magicError, isCaptchaRequired, processedAccount: account, magicTrack: trackId, magicCSRF: csrfToken},
        settings: {language}
    } = state;
    const fieldError = (magicError && (errors[magicError] || errors.global)) || null;
    const iconLang = !language || ['ru', 'uk'].includes(language) ? 'ru' : 'en';
    const authMethods = (account && account.allowed_auth_methods) || [];
    const isAccountWith2FA = authMethods.includes('magic') && authMethods.includes('otp');

    return {
        csrfToken,
        isCaptchaRequired,
        fieldError,
        magicIcon: isAccountWith2FA ? 'yandexKey' : `yandex3-${iconLang}`,
        trackId
    };
}
