import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Icon} from '@components/Icon';

const b = cn('MagicField');

export default function MagicField({trackId, fieldError, icon, className}) {
    const fieldStyle = trackId ? {backgroundImage: `url('/auth/magic/code/?track_id=${trackId}')`} : {};

    return (
        <div
            className={b(
                {
                    hidden: !trackId
                },
                [className]
            )}
        >
            {Boolean(fieldError) && <div className={b('error')} dangerouslySetInnerHTML={{__html: fieldError}} />}

            <div className={b('qr')} style={fieldStyle}>
                {icon && (
                    <span className={b('icon', {[icon]: true})}>
                        <Icon type={icon} size='l' />
                    </span>
                )}
            </div>
        </div>
    );
}

MagicField.propTypes = {
    fieldError: PropTypes.string,
    className: PropTypes.string,
    trackId: PropTypes.string,
    icon: PropTypes.oneOf(['yandexKey', 'yandex3-en', 'yandex3-ru', 'yandex2', 'yandex2-en', 'yandex2-ru'])
};
