import './AuthMessengerButton.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {cn} from '@bem-react/classname';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import AuthLetterCaptcha from '../../AuthLetterCaptcha/AuthLetterCaptcha.jsx';
import resizeAuthScreen from '../../../utils/resizeAuthScreen';
import {Button} from '@components/Button';
import {Popup} from '@components/Popup';
import {Icon} from '@components/Icon';

const b = cn('AuthMessengerButton');

export class AuthMessengerButton extends Component {
    buttonRef = React.createRef();

    componentWillUnmount() {
        this.props.setAuthMessengerError('');
        resizeAuthScreen();
    }

    componentDidUpdate(prevProps) {
        if (!prevProps.shouldErrorDisappear && this.props.shouldErrorDisappear) {
            resizeAuthScreen();
            setTimeout(() => {
                this.props.setAuthMessengerError('');
            }, 6000);
        }
    }

    render() {
        const {error, isCaptchaRequired} = this.props;

        if (isCaptchaRequired) {
            return <AuthLetterCaptcha handleCaptcha={this.props.handleCaptcha} />;
        }

        return (
            <>
                <Button
                    size='l'
                    view='default'
                    type='button'
                    width='max'
                    controlRef={this.buttonRef}
                    onClick={this.props.sendRequestToMessenger}
                    dataT='auth-messenger'
                >
                    <Icon size='s' place='button' type='key' />
                    {i18n('_AUTH_.MagicLink.btn.v2')}
                </Button>
                <Popup
                    visible={Boolean(error && !isCaptchaRequired)}
                    view='black'
                    target='anchor'
                    anchor={this.buttonRef}
                    directions={['bottom-center']}
                    style={{maxWidth: '350px'}}
                    keepMounted={false}
                >
                    <div className={b('error')}>{error}</div>
                </Popup>
                <div className={b('description')}>{i18n('_AUTH_.AuthMessenger.desc')}</div>
            </>
        );
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(AuthMessengerButton);

AuthMessengerButton.propTypes = {
    error: PropTypes.string,
    isCaptchaRequired: PropTypes.bool,
    shouldErrorDisappear: PropTypes.bool,
    setAuthMessengerError: PropTypes.func.isRequired,
    sendRequestToMessenger: PropTypes.func.isRequired,
    handleCaptcha: PropTypes.func.isRequired
};
