import {bindActionCreators} from 'redux';

import checkCaptcha from '../../../actions/checkCaptcha';
import checkAuthLetterStatus from '../../../actions/checkAuthLetterStatus';
import {setAuthMessengerError} from '../../../actions/messengerAuth';
import sendRequestToMessenger from '../../../actions/messengerAuth/sendRequestToMessenger';

export default function mapDispatchToProps(dispatch) {
    const actionsToBind = {
        checkCaptcha,
        handleCaptcha: (event) => {
            return () => {
                event.preventDefault();
                dispatch(checkCaptcha({action: checkAuthLetterStatus}));
            };
        },
        checkAuthLetterStatus,
        setAuthMessengerError,
        sendRequestToMessenger
    };

    return Object.assign({}, bindActionCreators(actionsToBind, dispatch), {dispatch});
}
