import authWithLetterErrors from '../../AuthWithLetterInfo/authWithLetterErrors';
import errors from '../../../errors';
import authMessengerErrors from '../errors';

export default function mapStateToProps(state) {
    const {messengerAuth} = state;
    const errorTexts = Object.assign({}, errors, authWithLetterErrors, authMessengerErrors);
    const error = messengerAuth.error && (errorTexts[messengerAuth.error] || errorTexts.global);
    const shouldErrorDisappear = messengerAuth.error === 'messenger_link.invalidated';
    const isCaptchaRequired = messengerAuth.error === 'captcha.required';

    return {
        error,
        isCaptchaRequired,
        shouldErrorDisappear
    };
}
