import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';

class ImageCode extends Component {
    render() {
        const {text, staticPath, code} = this.props;
        const codeDescription = code ? text : i18n('_AUTH_.Errors.internal');

        return (
            <div>
                {code && (
                    <ul className='al-send-popup__code'>
                        {code.map((d, index) => (
                            <li className='popup__code-item' key={index}>
                                <img
                                    className='popup__code-item-img'
                                    src={`${staticPath}/i/magic-letter/${d}.png`}
                                    alt='magic link code image'
                                />
                            </li>
                        ))}
                    </ul>
                )}
                <div className='al-send-popup__code-descr' dangerouslySetInnerHTML={{__html: codeDescription}} />
            </div>
        );
    }
}

export default connect(mapStateToProps)(ImageCode);

ImageCode.propTypes = {
    text: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired,
    code: PropTypes.array.isRequired
};
