import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import Title from '../../Title/Title.jsx';
import PagePopupContent from '../../PagePopupContent/PagePopupContent.jsx';

class Popup extends Component {
    render() {
        const linkForAndroid = 'https://redirect.appmetrica.yandex.com/serve/458404701881276453?c=passport_bage';
        const linkForIOs = 'https://redirect.appmetrica.yandex.com/serve/386347106450828605?c=passport_bage';
        const {sendRequestToMessenger, closePopup} = this.props;

        return (
            <PagePopupContent cls='al-send-popup' dataT='messenger-auth-info'>
                <Title cls='auth-messenger_popup-title'>{i18n('_AUTH_.AuthMessenger.has_no_app')}</Title>

                <h4 className='auth-messenger_title'>
                    <div className='passp-magic-promo-title__image' />
                    <span>{i18n('_AUTH_.AuthMessenger.enter_with_app')}</span>
                </h4>

                <ol className='auth-messenger-how-to_list'>
                    <li>
                        {i18n('_AUTH_.AuthMessenger.add_app')}
                        <div className='auth-messenger_app-btns'>
                            <a
                                className='passp-install-yandex-app-link'
                                target='_blank'
                                href={linkForAndroid}
                                title='Google Play'
                                rel='noopener noreferrer'
                            >
                                <div className='passp-gplay-icon' />
                            </a>
                            <a
                                className='passp-install-yandex-app-link'
                                target='_blank'
                                href={linkForIOs}
                                title='App Store'
                                rel='noopener noreferrer'
                            >
                                <div className='passp-appstore-icon' />
                            </a>
                        </div>
                    </li>
                    <li>{i18n('_AUTH_.AuthMessenger.instruction1')}</li>
                    <li>{i18n('_AUTH_.AuthMessenger.instruction2')}</li>
                </ol>

                <div className='auth-messenger_links'>
                    <Link className='popup-action' pseudo={true} onClick={sendRequestToMessenger}>
                        {i18n('_AUTH_.AuthMessenger.try_again')}
                    </Link>
                    <Link className='popup-action' pseudo={true} onClick={closePopup}>
                        {i18n('_AUTH_.MagicLink.password_enter')}
                    </Link>
                </div>
            </PagePopupContent>
        );
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Popup);

Popup.propTypes = {
    messengerAuth: PropTypes.obj,
    sendRequestToMessenger: PropTypes.func.isRequired,
    invalidateAuthFromLetter: PropTypes.func.isRequired,
    closePopup: PropTypes.func.isRequired
};
