import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import mapStateToProps from './mapStateToProps';
import Title from '../../Title/Title.jsx';
import PagePopupContent from '../../PagePopupContent/PagePopupContent.jsx';
import ImageCode from '../ImageCode/ImageCode.jsx';
import invalidateAuthFromLetter from '../../../actions/invalidateAuthFromLetter';
import CheckAuthWithMailStatus from '../../CheckAuthWithMailStatus/CheckAuthWithMailStatus.jsx';

const ICON = '<span class="auth-messenger-icon"></span>';

class Popup extends Component {
    constructor(props) {
        super(props);

        this.handleCloseClick = this.handleCloseClick.bind(this);
    }

    handleCloseClick() {
        const {dispatch, closePopup} = this.props;

        closePopup();
        dispatch(invalidateAuthFromLetter());
    }

    render() {
        return (
            <PagePopupContent cls='al-send-popup' dataT='messenger-auth'>
                <Title>
                    <span
                        dangerouslySetInnerHTML={{
                            __html: i18n('_AUTH_.AuthMessenger.title').replace('%icon', ICON)
                        }}
                    />
                </Title>

                <ImageCode text={i18n('_AUTH_.AuthMessenger.note')} />

                <span
                    role='button'
                    className='al-send-popup__close-link link_theme_normal'
                    onClick={this.handleCloseClick}
                >
                    {i18n('_AUTH_.MagicLink.password_enter')}
                </span>
                <CheckAuthWithMailStatus />
            </PagePopupContent>
        );
    }
}

export default connect(mapStateToProps)(Popup);

Popup.propTypes = {
    dispatch: PropTypes.func.isRequired,
    closePopup: PropTypes.func.isRequired
};
