import metrika from '@blocks/metrics';
import React from 'react';
import PropTypes from 'prop-types';
import PagePopupContent from '@blocks/authv2/components/PagePopupContent/PagePopupContent.jsx';
import Form from '@blocks/authv2/components/Form/Form.jsx';
import {PhoneConfirmation} from '@screens/PhoneConfirmation';

class NeoPhonishAuthConfirmationBySMSPopup extends React.PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана подтверждения телефона с помощью СМС для неофониша');
    }

    onConfirm = () => {
        const {commitNeoPhonishAuth} = this.props;

        commitNeoPhonishAuth();
    };

    onRetry = () => {
        const {retryToRequestPhoneConfirmationCode, trackId} = this.props;

        retryToRequestPhoneConfirmationCode(trackId);
    };

    render() {
        return (
            <PagePopupContent cls='NeoPhonishAuthConfirmationBySMSPopup' dataT='neophonish-auth-confirmation-by-sms'>
                <Form
                    withoutOffset={true}
                    cls='NeoPhonishAuthConfirmationBySMSPopup'
                    dataT='neophonish-auth-confirmation-by-sms'
                >
                    <PhoneConfirmation onConfirm={this.onConfirm} onRetry={this.onRetry} place='auth' />
                </Form>
            </PagePopupContent>
        );
    }
}

NeoPhonishAuthConfirmationBySMSPopup.propTypes = {
    retryToRequestPhoneConfirmationCode: PropTypes.func.isRequired,
    commitNeoPhonishAuth: PropTypes.func.isRequired,
    trackId: PropTypes.string.isRequired
};

export {NeoPhonishAuthConfirmationBySMSPopup};
