import {connect} from 'react-redux';
import {NeoPhonishAuthConfirmationBySMSPopup} from './NeoPhonishAuthConfirmationBySMSPopup.jsx';
import {retryToRequestPhoneConfirmationCode} from '@blocks/actions/phoneConfirm';
import {commitNeoPhonishAuth} from '@blocks/actions/neoPhonish';
import {getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';

const mapStateToProps = (state) => ({trackId: getTrackId(state, TRACK_TYPES.AUTH)});

const mapDispatchToProps = {
    retryToRequestPhoneConfirmationCode,
    commitNeoPhonishAuth
};

const ConnectedNeoPhonishAuthConfirmationBySMSPopup = connect(
    mapStateToProps,
    mapDispatchToProps
)(NeoPhonishAuthConfirmationBySMSPopup);

export {ConnectedNeoPhonishAuthConfirmationBySMSPopup as NeoPhonishAuthConfirmationBySMSPopup};
