import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {CLICK_RESTORE_ACCESS_LINK, SHOW_OTP_FORM} from '../../metrics_constants';
import metrics from '../../../metrics';
import mapStateToProps from './mapStateToProps';
import {Password} from '@components/Password';
import switchToRestorePassword from '@blocks/authv2/actions/switchToRestorePassword';

class OTPField extends Component {
    fieldOptions = {
        autoCorrect: 'off',
        autoCapitalize: 'off',
        autoComplete: 'one-time-code'
    };

    fieldLink = {};

    constructor(props) {
        super(props);

        this.patchFieldLink();
    }

    componentDidMount() {
        metrics.send([SHOW_OTP_FORM]);
    }

    patchFieldLink = () => {
        const {login, fieldLink, dispatch} = this.props;

        this.fieldLink = Object.assign({}, fieldLink);
        this.fieldLink.onClick = (event) => {
            metrics.send([SHOW_OTP_FORM, CLICK_RESTORE_ACCESS_LINK]);

            if (login) {
                event.preventDefault();
                dispatch(switchToRestorePassword());
            }
        };
    };

    render() {
        const {password, isShowFieldLink, onChange, login, fieldError} = this.props;

        return (
            <>
                <input
                    className='g-hidden'
                    type='text'
                    name='login'
                    id='login'
                    readOnly={true}
                    autoCorrect='off'
                    autoCapitalize='off'
                    autoComplete='username'
                    value={login}
                />

                <Password
                    hasToggler={true}
                    shouldValidate={false}
                    size='l'
                    label={i18n('_AUTH_.enter_otp_title')}
                    value={password}
                    name='passwd'
                    error={fieldError}
                    link={this.fieldLink}
                    options={this.fieldOptions}
                    isShowFieldLink={isShowFieldLink}
                    onChange={onChange}
                    view='big-input'
                />
            </>
        );
    }
}

OTPField.defaultProps = {
    fieldValue: ''
};

OTPField.propTypes = {
    password: PropTypes.string,
    isShowFieldLink: PropTypes.bool.isRequired,
    onChange: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired,
    login: PropTypes.string,
    fieldError: PropTypes.string,
    fieldLink: PropTypes.shape({
        url: PropTypes.string.isRequired,
        text: PropTypes.string.isRequired,
        onClick: PropTypes.func.isRequired
    }).isRequired
};

export default connect(mapStateToProps)(OTPField);
