import errors from '../../errors';
import processPasswordError from './processPasswordError';

export default function mapStateToProps(state) {
    const {
        auth: {
            passwordError,
            form: {login, password}
        },
        common: {restorePasswordCaptchaUrl, restorePasswordUrl}
    } = state;
    const withLoginLink = restorePasswordCaptchaUrl.includes('?')
        ? `${restorePasswordCaptchaUrl}&login=${login}`
        : `${restorePasswordCaptchaUrl}?login=${login}`;
    const fieldLink = {
        url: login ? withLoginLink : restorePasswordUrl,
        text: i18n('_AUTH_.restore_access'),
        onClick: () => {}
    };
    const fieldError = processPasswordError(passwordError);
    const isShowFieldLink =
        !fieldError ||
        (fieldError !== errors.global &&
            [
                'captcha.required',
                'csrf_token.invalid',
                'password.not_matched',
                'account.disabled',
                'account.disabled_on_deletion',
                'sessionid.overflow'
            ].indexOf(passwordError) === -1);

    return {
        password,
        isShowFieldLink,
        login,
        fieldError,
        fieldLink
    };
}
