import errors from '../../errors';
import trimLastDot from '../../utils/trimLastDot';

export default function processPasswordError(passwordError) {
    if (!passwordError) {
        return '';
    }

    if (passwordError === 'captcha.required') {
        return '';
    }

    if (passwordError === 'password.not_matched') {
        return errors['password.not_matched_2fa'];
    }

    return trimLastDot(errors[passwordError] || errors.global);
}
